<?php

defined('BASEPATH') OR exit('No direct script access allowed');



/*

| -------------------------------------------------------------------------

| URI ROUTING

| -------------------------------------------------------------------------

| This file lets you re-map URI requests to specific controller functions.

|

| Typically there is a one-to-one relationship between a URL string

| and its corresponding controller class/method. The segments in a

| URL normally follow this pattern:

|

|	example.com/class/method/id/

|

| In some instances, however, you may want to remap this relationship

| so that a different class/function is called than the one

| corresponding to the URL.

|

| Please see the user guide for complete details:

|

|	https://codeigniter.com/user_guide/general/routing.html

|

| -------------------------------------------------------------------------

| RESERVED ROUTES

| -------------------------------------------------------------------------

|

| There are three reserved routes:

|

|	$route['default_controller'] = 'welcome';

|

| This route indicates which controller class should be loaded if the

| URI contains no data. In the above example, the "welcome" class

| would be loaded.

|

|	$route['404_override'] = 'errors/page_missing';

|

| This route will tell the Router which controller/method to use if those

| provided in the URL cannot be matched to a valid route.

|

|	$route['translate_uri_dashes'] = FALSE;

|

| This is not exactly a route, but allows you to automatically route

| controller and method names that contain dashes. '-' isn't a valid

| class or method name character, so it requires translation.

| When you set this option to TRUE, it will replace ALL dashes in the

| controller and method URI segments.

|

| Examples:	my-controller/index	-> my_controller/index

|		my-controller/my-method	-> my_controller/my_method

*/



//cacategory



$route['default_controller'] = 'home';

$route['/'] = 'home';

$route['login'] = 'home/login';

$route['logout'] = 'home/logout';

$route['user'] = 'home/user';
$route['add_user'] = 'home/add_user';
$route['dashboard'] = 'home/dashboard';
$route['insert_user'] = 'home/insert_user';
$route['view_user/(:any)'] = 'home/view_user/$1';
$route['edit_user/(:any)'] = 'home/edit_user/$1';
$route['update_user'] = 'home/update_user';
$route['delete_user/(:any)'] = 'home/delete_user/$1';
$route['test/(:any)'] = 'test/test/$1';

//user rights
$route['user_rights'] = 'home/user_rights';
$route['add_user_rights'] = 'home/add_user_rights';


//products
$route['products'] = 'home/products';
$route['add_products'] = 'home/add_products';
$route['insert_products'] = 'home/insert_products';
$route['view_products/(:any)'] = 'home/view_products/$1';
$route['edit_products/(:any)'] = 'home/edit_products/$1';
$route['update_products'] = 'home/update_products';
$route['delete_product/(:any)/(:any)'] = 'home/delete_product/$1/$2';

//Billing
$route['billing'] = 'home/billing';
$route['add_billing'] = 'home/add_billing';
$route['insert_billing'] = 'home/insert_billing';
$route['view_billing/(:any)'] = 'home/view_billing/$1';
$route['month_bill/(:any)'] = 'home/month_bill/$1';
$route['edit_billing/(:any)'] = 'home/edit_billing/$1';
$route['update_billing'] = 'home/update_billing';
$route['delete_billing/(:any)'] = 'home/delete_billing/$1';

//expence
$route['expence'] = 'home/expence';
$route['add_expence'] = 'home/add_expence';
$route['insert_expence'] = 'home/insert_expence';
$route['edit_expence/(:any)'] = 'home/edit_expence/$1';
$route['update_expence'] = 'home/update_expence';


//expence cost
$route['expence_cost'] = 'home/expence_cost';
$route['add_expence_cost'] = 'home/add_expence_cost';
$route['insert_expence_cost'] = 'home/insert_expence_cost';
$route['view_expence_cost/(:any)'] = 'home/view_expence_cost/$1';
$route['edit_expence_cost/(:any)'] = 'home/edit_expence_cost/$1';
$route['update_expence_cost'] = 'home/update_expence_cost';
$route['delete_expence_cost/(:any)'] = 'home/delete_expence_cost/$1';


//day closing
$route['dayclosing'] = 'home/dayclosing';
$route['add_dayclosing'] = 'home/add_dayclosing';
$route['insert_dayclosing'] = 'home/insert_dayclosing';
$route['current_month_dayclose/(:any)'] = 'home/current_month_dayclose/$1';
$route['view_dayclosing/(:any)'] = 'home/view_dayclosing/$1';
$route['edit_dayclsoing/(:any)'] = 'home/edit_dayclosing/$1';
$route['update_dayclosing'] = 'home/update_dayclosing';
$route['delete_dayclosing/(:any)'] = 'home/delete_dayclosing/$1';



//bank
$route['bank'] = 'home/bank';
$route['add_bank'] = 'home/add_bank';
$route['insert_bank'] = 'home/insert_bank';
$route['edit_bank/(:any)'] = 'home/edit_bank/$1';
$route['update_bank'] = 'home/update_bank';



//bank transfer
$route['bank_transfer'] = 'home/bank_transfer';
$route['add_transfer'] = 'home/add_transfer';
$route['insert_transfer'] = 'home/insert_transfer';
$route['edit_transfer/(:any)'] = 'home/edit_transfer/$1';
$route['update_transfer'] = 'home/update_transfer';
$route['bank_reports'] = 'home/bank_reports';
$route['bank_individaul_reports/(:any)'] = 'home/bank_individaul_reports/$1';
$route['daily_transfer/(:any)'] = 'home/daily_transfer/$1';
$route['week_transfer/(:any)'] = 'home/week_transfer/$1';




//bill filter
$route['weekly_bill/(:any)'] = 'home/weekly_bill/$1';
$route['daily_bill/(:any)'] = 'home/daily_bill/$1';


//dayclose filter
$route['weekly_dayclose/(:any)'] = 'home/weekly_dayclose/$1';
$route['daily_dayclose/(:any)'] = 'home/daily_dayclose/$1';

///expnec filter
$route['weekly_expence/(:any)'] = 'home/weekly_expence/$1';
$route['daily_expence/(:any)'] = 'home/daily_expence/$1';


//location
$route['location'] = 'home/location';
$route['add_location'] = 'home/add_location';
$route['insert_location'] = 'home/insert_location';
$route['view_location/(:any)'] = 'home/view_location/$1';
$route['edit_location/(:any)'] = 'home/edit_location/$1';
$route['update_location'] = 'home/update_location';
$route['delete_location/(:any)'] = 'home/delete_location/$1';

$route['checkproduct/(:any)'] = 'home/checkproduct/$1';

//expence
$route['expence_approve_view'] = 'home/expence_approve_view';
$route['approve_expence/(:any)'] = 'home/approve_expence/$1';
$route['cancel_expence/(:any)'] = 'home/cancel_expence/$1';

//viewall

$route['viewall/(:any)'] = 'home/viewall/$1';


//admin expence
$route['admin_expence'] = 'home/admin_expence';
$route['total_sales'] = 'home/total_sales';

//admin edit 
$route['edit_billing'] = 'home/edit_billing';
$route['edit_expence_cost'] = 'home/edit_expence_cost';
$route['edit_dayclosing'] = 'home/edit_dayclosing';
$route['location_bill'] = 'home/location_bill';
$route['date_bill'] = 'home/date_bill';
$route['bill_edit/(:any)'] = 'home/bill_edit/$1';
$route['update_bill'] = 'home/update_bill';
$route['dayclose_edit'] = 'home/dayclose_edit';
$route['close_edit/(:any)'] = 'home/edit_dayclosing/$1';
$route['location_close'] = 'home/location_close';
$route['date_close'] = 'home/date_close';
$route['expence_adminview'] = 'home/expence_adminview';
$route['location_expence'] = 'home/location_expence';
$route['date_expence'] = 'home/date_expence';
$route['profile_edit'] = 'home/profile_edit';
$route['update_profile'] = 'home/update_profile';

//pdf data

$route['allreport'] = 'home/allreport';
$route['pdf_report'] = 'home/pdf_report';

//open balance
$route['open_balance'] = 'home/open_balance';
$route['viewopen_balance'] = 'home/viewopen_balance';
$route['insert_openbal'] = 'home/insert_openbal';
$route['edit_openbal/(:any)'] = 'home/edit_openbal/$1';
$route['update_openbal'] = 'home/update_openbal';
